﻿# -*- coding: utf-8 -*-
# La ligne ci-dessus évite les problèmes d'accents quand on passe d'un éditeur à l'autre.

import numpy as np
import matplotlib.pyplot as plt


# Données supposées être expérimentales :
hauteurs = [ np.random.rand()*10 for i in range(100) ]
temps_de_chute = [ np.sqrt(2*h/9.81)*(0.9+0.2*np.random.rand()) for h in hauteurs ]



def lit_csv(chemin):
    fichier = open(chemin, "r") #Ouverture du fichier en lecture
    # On initialise les listes
    hauteurs=[]
    temps=[]
    
    for ligne in fichier: # Parcourt toutes les lignes du fichier
        
        h, t = ligne.strip().split(";")
        # Le .strip() supprime les caractères invisibles en début et fin de ligne. Ici les retours charriot.
        # Le .split(";") découpe la ligne selon les point-virgules
        
        # Il faut encore convertir h et t en flottant : ce sont actuellement des chaînes de caractères.
        h=float(h)
        t=float(t)
        
        hauteurs.append(h)
        temps.append(t)
        
    fichier.close()
    return  hauteurs, temps




# Programme utilisé pour créer artificiellement un fichier csv pour le stage...
def crée_csv(chemin="/media/moi/CYRIL/formation/pour physique/pommes.csv"):
    """ Crée un fichier csv contenant des mesures de chute de pommes"""
    
    fichier = open(chemin, "w") #Ouverture du fichier en écriture
    for i in range(len(hauteurs)):
        fichier.write( str(hauteurs[i]) +";" + str(temps_de_chute[i])+"\n")
    fichier.close()
